import credentials
import netmiko
import ipaddress
import os
import subprocess
import re
import pandas as pd

CODE_REV = '0.0'
SERVER_MODE = False
CURRENT_DIR = os.path.dirname(os.path.abspath(__file__))

df_inventory = pd.DataFrame(columns=['ssh','Ip','Hostname','PartNumber', 'SN' , 'Version'])

def ping_host(ip):
    #ip_str = str(ip) if isinstance(ip, ipaddress.IPv4Address) else ip
    if os.name == 'nt':  # Windows
        cmd = ["ping", "-n", "1", "-w", "100", ip_str]
    else:  # Unix/Linux/Mac
        cmd = ["ping", "-c", "1", "-W" , "0.10", ip_str]

    try:
        response = subprocess.run(cmd, stdout=subprocess.DEVNULL, stderr=subprocess.DEVNULL)
        return response.returncode == 0
    except Exception as e:
        print(f"Erro ao executar ping: {e}")
        return False

def collect_data(Ip):

    credentials.my_device['host'] = Ip
    ssh = False
    Ip = None
    hostname = None
    PartNumber = None
    Sn = None
    Version = None

    try:
        cisco =  netmiko.ConnectHandler(**credentials.my_device)
        ssh = True
    except:
        print(f'ssh FAIL')
        return {    'ssh' : str(ssh),
                    'Ip' : Ip,
                    'Hostname' : '',
                    'PartNumber' : '',
                    'SN'  : '',
                    'Version':''}

    hostname = cisco.find_prompt()[:-1]

    show_version_output = cisco.send_command('show version')

    pattern_section_platform = re.compile(r"Model\s+Number\s*:\s*(\S+)", re.DOTALL)
    pattern_section_sn = re.compile(r"Motherboard\s+Serial\s+Number\s*:\s*(\S+)", re.DOTALL)
    pattern_section_version = re.compile(r"Version\s+((\d+\.\d+\.\d+)|(\d+\.\d+\(\d+\)[A-Za-z]*(\d*)?))", re.DOTALL)
    
    match_section = pattern_section_platform.search(show_version_output)
    PartNumber = match_section.group(1)

    match_section = pattern_section_sn.search(show_version_output)
    Sn = match_section.group(1)
    
    match_section = pattern_section_version.search(show_version_output)
    Version = match_section.group(1)

    return {'ssh'       : str(ssh),
            'Ip'        : Ip,
            'Hostname'  : hostname,
            'PartNumber': PartNumber,
            'SN'        : Sn,
            'Version'   : Version
            }

if __name__ == '__main__':

    print('****************************************************')
    print('* Logicalis Inventory Collector [Rev'+CODE_REV+'] @JAN/2025')
    print('* By: Victor Curti @Logicalis')
    print('* -> Only Cisco Equipments')
    print('****************************************************')

    # Create dataframe with valid IPs
    for addr in ipaddress.IPv4Network(credentials.information['range_ip']):
        ip_str = str(addr) if isinstance(addr, ipaddress.IPv4Address) else addr
        status = ping_host(ip_str)
        print(f'Verify {ip_str} - {'Reachable' if status else 'Unreachable'}')
        if status:
            df_inventory.loc[len(df_inventory)] =  {'ssh' : None,
                                                    'Ip' : ip_str,
                                                    'Hostname' : None,
                                                    'PartNumber' : None,
                                                    'SN'  : None,
                                                    'Version':None
                                                    }

    for i, row in df_inventory.iterrows():
        print(f'-> Connecting to: {row['Ip']}')
        result = collect_data(row['Ip'])
        df_inventory.loc[i] = result

    rev = 0
    network_address, network_mask = credentials.information['range_ip'].replace('.','_').split('/')  # Retorna o endereço de rede
    while True:
        file_name = os.path.join(CURRENT_DIR, 'output' ,f'Inventory_{network_address}_{network_mask}_Rev{rev}.xlsx')
        if os.path.exists(file_name):
            print(f"The file '{file_name}' already exists.")
            rev = rev + 1
        else:
            df_inventory.to_excel(file_name,index=False)
            print(f"The file '{file_name}' has been created.")
            exit()
